 ; Nail - install notes into a drawing.
 ; Copyright 1996, 2002, 2008, 2010 by Rocket Software Ltd.
 ; Why can't you draw a picture of an abstract concept?

 ; Whilin - draw text until nothing is entered after the initial number
 ; entity, then erase that and quit.
 (DEFUN WHILIN (pa num / goon dimscl hght enam)
  (setq num (1- num))
  (malaya "text")
  (setq dimscl (misps))
  (setq hght (* 2.5 dimscl))
  (setq goon t)
  (while goon
         (command "text" "r" pa hght "0"
                         (strcat (itoa (setq num (1+ num))) "."))
         (setq enam (entlast))
         (setq pa (polar pa 0 (* 2.5 dimscl)))
         (command "dtext" pa hght "0")
         (if (equal (entlast) enam)
             (progn
                  (setq goon ())
                  (entdel enam))
             (progn
                  (setq pa (cdr (assoc 10 (entget (entlast)))))
                  (setq pa (polar pa pi (* 2.5 dimscl)))
                  (setq pa (polar pa (* pi 1.5) (* 5 dimscl))))))
  (if (= (cdr (assoc 1 (entget (entlast)))) "NOTES:")
      (entdel (entlast)))
 (princ))

 ; Subroutine N2 - continue below an existing N. string.
 (DEFUN N2 (pa num / dimscl)
(print "n2")
  (setq dimscl (misps))
  (setq pa (polar pa (* pi 1.5) (* 5 dimscl)))
  (whilin pa (1+ num))
 (princ))

 ; Subroutine N3 - continue below an existing text string.
 (DEFUN N3 (pa / num dimscl)
(print "n3")
  (setq num (getint "\nNote number: "))
  (setq dimscl (misps))
  (setq pa (polar pa pi (* 2.5 dimscl)))
  (setq pa (polar pa (* pi 1.5) (* 5 dimscl)))
  (whilin pa num)
 (princ))

 ; Subroutine Note - start the note text.
 (DEFUN NOTE (pa / hght dimscl num)
  (malaya "text")
  (setq hght (* 3 (setq dimscl (misps))))
  (command "text" pa hght "0" "NOTES:")
  (setq pa (polar pa (* pi 1.5) (* 5 dimscl)))
  (setq num 1)
  (whilin pa num)
 (princ))

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Nail - the all-purpose fastener.                                      
 ; 
 (DEFUN C:NAIL (/ *error* pa nent entt ten str num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (setvar "osmode" osmo)
  (if shk (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get a start point.                                                    
 ; 
  (setq pa (getpoint "Start point or previous line: "))
  (if (and (setq nent (nentselp pa))
           (setq entt (entget (car nent)))
           (= (cdr (assoc 0 entt)) "TEXT"))
      (progn
           (setq ten (spit entt))
           (setq str (cdr (assoc 1 entt)))))
  (cond ((and str
              (>= (strlen str) 2)
              (numberp (setq num (read (substr str 1 1))))
              (= (substr str (strlen str)) "."))
         (n2 ten num))
        (str
         (n3 ten))
        (t
         (note pa)))
 ; Ŀ
 ;   Restore sysvars, end.                                                 
 ; 
  (*error* ())
 (princ))